/*
 * Decompiled with CFR 0.152.
 */
package com.github.charlyb01.music_control.categories;

import com.github.charlyb01.music_control.Utils;
import com.github.charlyb01.music_control.categories.Music;
import com.github.charlyb01.music_control.categories.MusicCategories;
import com.github.charlyb01.music_control.client.MusicControlClient;
import com.github.charlyb01.music_control.client.SoundEventRegistry;
import com.github.charlyb01.music_control.config.DimensionEventChance;
import com.github.charlyb01.music_control.config.MiscEventChance;
import com.github.charlyb01.music_control.config.ModConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6880;

public class MusicIdentifier {
    private MusicIdentifier() {
    }

    public static HashSet<Music> getListFromEvent(class_2960 eventId, class_1657 player, class_1937 world, class_5819 random) {
        boolean playerNotNull;
        HashSet<Music> musics = new HashSet<Music>();
        if (ModConfig.get().general.event.miscEventChance.equals((Object)MiscEventChance.HALF) && random.method_43056()) {
            musics.addAll(MusicIdentifier.getListFromEvent(eventId));
            MusicIdentifier.addDimensionEvent(musics, world, random);
            return musics;
        }
        boolean bl = playerNotNull = player != null;
        if (playerNotNull && player.method_6128()) {
            musics.addAll(MusicIdentifier.getListFromEvent(MusicIdentifier.getFromSoundEvent(SoundEventRegistry.PLAYER_FLYING)));
        }
        if (playerNotNull && player.method_5765()) {
            musics.addAll(MusicIdentifier.getListFromEvent(MusicIdentifier.getFromSoundEvent(SoundEventRegistry.PLAYER_RIDING)));
        }
        if (Utils.isNight(world)) {
            musics.addAll(MusicIdentifier.getListFromEvent(MusicIdentifier.getFromSoundEvent(SoundEventRegistry.TIME_NIGHT)));
        }
        if (world.method_8419()) {
            musics.addAll(MusicIdentifier.getListFromEvent(MusicIdentifier.getFromSoundEvent(SoundEventRegistry.WEATHER_RAIN)));
        }
        if (world.method_8546()) {
            musics.addAll(MusicIdentifier.getListFromEvent(MusicIdentifier.getFromSoundEvent(SoundEventRegistry.WEATHER_THUNDER)));
        }
        if (!ModConfig.get().general.event.miscEventChance.equals((Object)MiscEventChance.PROPORTIONAL) && !musics.isEmpty()) {
            return musics;
        }
        musics.addAll(MusicIdentifier.getListFromEvent(eventId));
        MusicIdentifier.addDimensionEvent(musics, world, random);
        return musics;
    }

    private static void addDimensionEvent(HashSet<Music> musics, class_1937 world, class_5819 random) {
        if (ModConfig.get().general.event.dimensionEventChance.equals((Object)DimensionEventChance.FALLBACK)) {
            return;
        }
        if (ModConfig.get().general.event.dimensionEventChance.equals((Object)DimensionEventChance.NEVER)) {
            return;
        }
        HashSet<Music> dimensionMusic = MusicIdentifier.getListFromEvent(MusicIdentifier.getDimension((class_5321<class_1937>)world.method_27983()));
        if (ModConfig.get().general.event.dimensionEventChance.equals((Object)DimensionEventChance.HALF)) {
            if (random.method_43056()) {
                return;
            }
            if (!dimensionMusic.isEmpty()) {
                musics.clear();
            }
        }
        musics.addAll(dimensionMusic);
    }

    public static HashSet<Music> getListFromEvent(class_2960 eventId) {
        HashSet<Music> musics = new HashSet<Music>();
        HashSet<class_2960> checkedEvents = new HashSet<class_2960>();
        ArrayList<class_2960> eventsToCheck = new ArrayList<class_2960>();
        eventsToCheck.add(eventId);
        while (!eventsToCheck.isEmpty()) {
            class_2960 event = (class_2960)eventsToCheck.removeFirst();
            if (checkedEvents.contains(event)) continue;
            musics.addAll((Collection<Music>)Music.MUSIC_BY_EVENT.get(event));
            checkedEvents.add(event);
            if (!Music.EVENTS_OF_EVENT.containsKey(event)) continue;
            eventsToCheck.addAll((Collection)Music.EVENTS_OF_EVENT.get(event));
        }
        return musics;
    }

    public static class_2960 getFromList(HashSet<Music> musics, class_5819 random) {
        class_2960 music;
        if (musics.isEmpty()) {
            return null;
        }
        int size = musics.size();
        while (MusicCategories.PLAYED_MUSICS.size() >= Math.min(ModConfig.get().general.misc.musicQueue, size)) {
            MusicCategories.PLAYED_MUSICS.poll();
        }
        ArrayList<Music> musicList = new ArrayList<Music>(musics);
        while (MusicCategories.PLAYED_MUSICS.contains(music = musicList.remove(random.method_43048(size--)).getIdentifier())) {
        }
        MusicCategories.PLAYED_MUSICS.add(music);
        return music;
    }

    public static class_2960 getFromCategory(class_5819 random) {
        if (Music.MUSIC_BY_NAMESPACE.containsKey(MusicControlClient.currentCategory)) {
            HashSet<Music> musics = Music.MUSIC_BY_NAMESPACE.get(MusicControlClient.currentCategory);
            return MusicIdentifier.getFromList(musics, random);
        }
        return null;
    }

    private static class_2960 getDimension(class_5321<class_1937> world) {
        class_2960 eventId = world.equals((Object)class_1937.field_25180) ? MusicIdentifier.getFromSoundEvent(SoundEventRegistry.NETHER) : (world.equals((Object)class_1937.field_25181) ? MusicIdentifier.getFromSoundEvent((class_6880.class_6883<class_3414>)class_3417.field_14631) : MusicIdentifier.getFromSoundEvent((class_6880.class_6883<class_3414>)class_3417.field_14681));
        return eventId;
    }

    public static class_2960 getFallback(class_5321<class_1937> world, boolean creative, class_5819 random) {
        HashSet<Music> musics = null;
        if (ModConfig.get().general.event.dimensionEventChance.equals((Object)DimensionEventChance.FALLBACK)) {
            musics = MusicIdentifier.getListFromEvent(MusicIdentifier.getDimension(world));
        }
        if ((musics == null || musics.isEmpty()) && ModConfig.get().general.event.creativeEventFallback && creative) {
            musics = MusicIdentifier.getListFromEvent(MusicIdentifier.getFromSoundEvent((class_6880.class_6883<class_3414>)class_3417.field_14995));
        }
        return musics == null || musics.isEmpty() ? Music.EMPTY_MUSIC_ID : MusicIdentifier.getFromList(musics, random);
    }

    public static class_2960 getFromSoundEvent(class_6880.class_6883<class_3414> soundEvent) {
        return ((class_3414)soundEvent.comp_349()).method_14833();
    }

    public static boolean isDimension(class_2960 identifier) {
        return identifier.equals((Object)MusicIdentifier.getFromSoundEvent((class_6880.class_6883<class_3414>)class_3417.field_14681)) || identifier.equals((Object)MusicIdentifier.getFromSoundEvent(SoundEventRegistry.NETHER)) || identifier.equals((Object)MusicIdentifier.getFromSoundEvent((class_6880.class_6883<class_3414>)class_3417.field_14631));
    }

    public static boolean isBiome(class_2960 identifier) {
        String path = identifier.method_12832();
        return path.startsWith("music.overworld.") || path.startsWith("music.nether.") || path.startsWith("music.end.");
    }

    public static boolean isDisc(class_2960 identifier) {
        return identifier.method_12832().startsWith("music_disc");
    }

    public static boolean isMisc(class_2960 identifier) {
        return identifier.method_12832().startsWith("music.misc.");
    }
}

